#include <p30fxxxx.h>
#include <timer.h>

/*******************************************************************
*    Function Name: ConfigIntTimer2                                *
*    Description:   This Function Configures Interrupt and sets    *
*                   Interrupt Priority                             *
*    Parameters:    unsigned int config                            *
*    Return Value:  None                                           *
*******************************************************************/

void ConfigIntTimer2(unsigned int config)
{
    IFS0bits.T2IF = 0;                   /* clear IF bit */
    IPC1bits.T2IP = (config &0x0007);    /* assigning Interrupt Priority */
    IEC0bits.T2IE = (config &0x0008)>>3; /* Interrupt Enable /Disable */
}
